/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.MultipartBlockStateGenerator;
import dev.latvian.mods.kubejs.client.StencilTexture;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.ResourceGenerator;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_156;
import net.minecraft.class_2960;

public class AssetJsonGenerator
extends ResourceGenerator {
    private final Map<String, StencilTexture> stencils = new HashMap<String, StencilTexture>();

    public AssetJsonGenerator(Map<class_2960, GeneratedData> m) {
        super(ConsoleJS.CLIENT, m);
    }

    public void blockState(class_2960 id, Consumer<VariantBlockStateGenerator> consumer) {
        VariantBlockStateGenerator gen = (VariantBlockStateGenerator)class_156.method_654((Object)new VariantBlockStateGenerator(), consumer);
        this.json(new class_2960(id.method_12836(), "blockstates/" + id.method_12832()), (JsonElement)gen.toJson());
    }

    public void multipartState(class_2960 id, Consumer<MultipartBlockStateGenerator> consumer) {
        MultipartBlockStateGenerator gen = (MultipartBlockStateGenerator)class_156.method_654((Object)new MultipartBlockStateGenerator(), consumer);
        this.json(new class_2960(id.method_12836(), "blockstates/" + id.method_12832()), (JsonElement)gen.toJson());
    }

    public void blockModel(class_2960 id, Consumer<ModelGenerator> consumer) {
        ModelGenerator gen = (ModelGenerator)class_156.method_654((Object)new ModelGenerator(), consumer);
        this.json(new class_2960(id.method_12836(), "models/block/" + id.method_12832()), (JsonElement)gen.toJson());
    }

    public void itemModel(class_2960 id, Consumer<ModelGenerator> consumer) {
        ModelGenerator gen = (ModelGenerator)class_156.method_654((Object)new ModelGenerator(), consumer);
        this.json(AssetJsonGenerator.asItemModelLocation(id), (JsonElement)gen.toJson());
    }

    public static class_2960 asItemModelLocation(class_2960 id) {
        return new class_2960(id.method_12836(), "models/item/" + id.method_12832());
    }

    public void stencil(class_2960 target, String stencil, JsonObject colors) throws IOException {
        StencilTexture st = this.stencils.get(stencil);
        if (st == null) {
            Path path = KubeJSPaths.ASSETS.resolve("kubejs/textures/stencil/" + stencil + ".png");
            if (Files.notExists(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Stencil file 'kubejs/assets/kubejs/textures/stencil/'" + stencil + ".png' not found!");
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                Path metaPath = KubeJSPaths.ASSETS.resolve("kubejs/textures/stencil/" + stencil + ".png.mcmeta");
                byte[] meta = null;
                if (Files.exists(metaPath, new LinkOption[0])) {
                    meta = Files.readAllBytes(metaPath);
                }
                st = new StencilTexture(ImageIO.read(in), meta);
                this.stencils.put(stencil, st);
            }
        }
        StencilTexture st1 = st;
        this.add(new class_2960(target.method_12836(), "textures/" + target.method_12832() + ".png"), () -> st1.create(colors), true);
        if (st.mcmeta != null) {
            this.add(new class_2960(target.method_12836(), "textures/" + target.method_12832() + ".png.mcmeta"), () -> st1.mcmeta, false);
        }
    }
}

